/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.LinkInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.security.Certificate;
import de.willuhn.jameica.security.Principal;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractCertificateDialog
extends AbstractDialog {
    private String text = null;
    private List<X509Certificate> certs = new LinkedList<X509Certificate>();
    private Input cnIssuer = null;
    private TextAreaInput altNames = null;
    private Input oIssuer = null;
    private Input cnSubject = null;
    private Input oSubject = null;
    private LabelInput validity = null;
    private Input serial = null;
    private Input fingerprint = null;

    public AbstractCertificateDialog(int position, X509Certificate cert) {
        this(position, Arrays.asList(cert));
    }

    public AbstractCertificateDialog(int position, List<X509Certificate> certs) {
        super(position);
        this.setSize(640, -1);
        this.certs.addAll(certs);
        this.cnIssuer = this.createLabel(this.i18n.tr("Common Name (CN)"));
        this.altNames = new TextAreaInput("");
        this.altNames.setHeight(50);
        this.altNames.setName(this.i18n.tr("Alternative Hostnamen"));
        this.altNames.setEnabled(false);
        this.oIssuer = this.createLabel(this.i18n.tr("Organisation (O)"));
        this.cnSubject = this.createLink(this.i18n.tr("Common Name (CN)"));
        this.oSubject = this.createLabel(this.i18n.tr("Organisation (O)"));
        this.validity = this.createLabel(this.i18n.tr("G\u00fcltigkeit"));
        this.serial = this.createLabel(this.i18n.tr("Seriennummer"));
        this.fingerprint = new TextAreaInput("");
        this.fingerprint.setEnabled(false);
    }

    private LabelInput createLabel(String name) {
        LabelInput label = new LabelInput("");
        label.setName(name);
        return label;
    }

    private LinkInput createLink(String name) {
        LinkInput link = new LinkInput(""){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    try {
                        InetAddress.getByName(value.toString());
                        super.setValue("<a>https://" + value + "</a>");
                        return;
                    }
                    catch (Exception e) {
                        Logger.write((Level)Level.DEBUG, (String)("unable to resolve text as hostname: " + value), (Throwable)e);
                    }
                }
                super.setValue(value);
            }
        };
        link.setName(name);
        link.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    new Program().handleAction(event.text);
                }
                catch (ApplicationException e) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getMessage(), 1));
                }
            }
        });
        return link;
    }

    private void fill(X509Certificate cert) throws CertificateEncodingException, NoSuchAlgorithmException {
        Certificate myCert = new Certificate(cert);
        Principal p = myCert.getIssuer();
        String cn = p.getAttribute("CN");
        String o = p.getAttribute("O");
        String ou = p.getAttribute("OU");
        this.cnIssuer.setValue(this.format(cn));
        this.oIssuer.setValue(this.format(o));
        p = myCert.getSubject();
        cn = p.getAttribute("CN");
        o = p.getAttribute("O");
        this.cnSubject.setValue(this.format(cn));
        List<String> alt = myCert.getHostnames();
        if (alt != null && alt.size() > 1) {
            alt.remove(0);
            this.altNames.setValue(StringUtils.join(alt, (String)"\n"));
        }
        this.oSubject.setValue(this.format(o));
        DateFormat df = DateUtil.DEFAULT_FORMAT;
        this.validity.setValue(this.i18n.tr("{0} - {1}", new String[]{df.format(cert.getNotBefore()), df.format(cert.getNotAfter())}));
        this.serial.setValue("0x" + cert.getSerialNumber().toString(16).toUpperCase());
        StringBuffer sb = new StringBuffer();
        sb.append(this.i18n.tr("SHA256:\n{0}", myCert.getSHA256Fingerprint().replaceAll("(.{48})", "$1\n")));
        sb.append("\n\n");
        sb.append(this.i18n.tr("SHA1:\n{0}", myCert.getSHA1Fingerprint()));
        this.fingerprint.setValue(sb.toString());
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException expired) {
            this.validity.setComment(Application.getI18n().tr("Zertifikat abgelaufen"));
            this.validity.setColor(Color.ERROR);
        }
        catch (CertificateNotYetValidException notyet) {
            this.validity.setComment(Application.getI18n().tr("Noch nicht g\u00fcltig"));
            this.validity.setColor(Color.ERROR);
        }
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        X509Certificate cert = this.certs.get(0);
        this.fill(cert);
        SimpleContainer group = new SimpleContainer(parent, true);
        if (this.text != null && this.text.length() > 0) {
            group.addText(this.text, true);
        }
        group.addHeadline(Application.getI18n().tr("Ausgestellt von"));
        group.addInput(this.cnIssuer);
        group.addInput(this.oIssuer);
        group.addHeadline(Application.getI18n().tr("Ausgestellt f\u00fcr"));
        group.addInput(this.cnSubject);
        group.addInput(this.oSubject);
        group.addInput(this.altNames);
        group.addHeadline(Application.getI18n().tr("Eigenschaften des Zertifikats"));
        group.addInput(this.validity);
        group.addInput(this.serial);
        group.addHeadline(Application.getI18n().tr("Fingerabdr\u00fccke"));
        group.addPart(this.fingerprint);
        SimpleContainer cb = new SimpleContainer(parent);
        ButtonArea buttons = new ButtonArea();
        this.paintButtons(buttons);
        cb.addButtonArea(buttons);
    }

    private String format(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() < 40) {
            return s;
        }
        return s.replaceAll(",", "\n");
    }

    protected abstract void paintButtons(ButtonArea var1);

    protected Object getData() throws Exception {
        return null;
    }

    public void setText(String text) {
        this.text = text;
    }
}

